----------------
title : C++ 레퍼런스 - ios_base::flags 함수
cat_title :  ios_base::flags
ref_title : flags, ios_base::flags
publish_date : 2011-08-19
path : /C++ Reference/iostream
--------------

##@ cpp-ref-start

#@ ios_base::flags

```cpp-formatted
fmtflags flags() const;
fmtflags flags(fmtflags fmtfl);
```


서식 플래그를 얻어오거나 설정한다.
첫번째 형태의 경우, 현재 스트림의 서식 플래그가 어떻게 설정되어 있는지 불러온다.
두번째 형태의 경우 스트림의 서식 플래그를 새롭게 설정하고, 원래 설정되어있던 것을 리턴한다.

서식 플래그는 입출력시 데이터가 어떻게 해석되고, 또 어떻게 출력되는지 결정해준다. `fmtfl` 로 무슨 값이 올 수 있는지 알려면 [ios_base::fmtflags](http://itguru.tistory.com/154)를 참조하여라

`fmtfl` 에 서식 플래그를 전달할 때, 기존의 스트림의 서식 플래그의 내용은 모두 지워지고, 전달된 `fmtfl` 의 내용으로 덮어 씌워지게 된다. 다른 서식 플래그를 바꾸지 않고, 한 개의 서식 플래그 만 바꾸기 위해서는 [setf](http://itguru.tistory.com/155)함수나 [unsetf](http://itguru.tistory.com/156)함수를 이용하면 된다.



###  인자

`fmtfl`

  스트림에서 사용되는 서식 플래그. 이 값은 [ios_base::fmtflags](http://itguru.tistory.com/154)형이다.


###  리턴값

함수 호출 직전의 서식 플래그

###  실행 예제

```cpp-formatted
/*

cout 의 서식 플래그로 right, hex, showbase 를 전달한다.
이를 통해 100 은 오른쪽에 10 크기로 맞추어서, 16 진수로, 무슨 진법으로(0x)
표시하였는지 명시되어 출력된다. 이 예제는
http://www.cplusplus.com/reference/iostream/ios_base/flags/
에서 가져왔습니다

*/
#include <iostream>
using namespace std;

int main() {
  cout.flags(ios::right | ios::hex | ios::showbase);
  cout.width(10);
  cout << 100;
  return 0;
}
```


실행 결과


![](http://img1.daumcdn.net/thumb/R1920x0/?fname=http%3A%2F%2Fcfile10.uf.tistory.com%2Fimage%2F110B09414E4D3E30316DF2)





###  연관된 것들

*  [ios_base::setf](http://itguru.tistory.com/155)  :  특정 서식 플래그를 설정한다.
*  [ios_base::unsetf](http://itguru.tistory.com/156)  :  특정 서식 플래그를 초기화 한다.
*  [ios_base::fmtflags](http://itguru.tistory.com/154)  :  스트림 서식 플래그의 타입
* `setiosflags` : 서식 플래그를 설정한다.